<?php
// handle_form.php
// This script processes the form from index.php

// Include header
include("header.php");

// Collect form data safely
$firstname = trim($_POST['first_name'] ?? "");
$lastname  = trim($_POST['last_name'] ?? "");
$email     = trim($_POST['email'] ?? "");
$gender    = $_POST['gender'] ?? "";
$comments  = trim($_POST['comments'] ?? "");
$interests = $_POST['interests'] ?? [];

// Keep track of missing fields
$missing = array();

if (empty($firstname)) { $missing[] = "First Name"; }
if (empty($lastname))  { $missing[] = "Last Name"; }
if (empty($email))     { $missing[] = "Email"; }
if (empty($gender))    { $missing[] = "Gender"; }
if (empty($comments))  { $missing[] = "Comments"; }

// Display results
if (count($missing) == 0) {
    echo "<h1>Thank You!</h1>";
    echo "<p>Here is the information you submitted:</p>";
    echo "<ul>";
    echo "<li><strong>First Name:</strong> $firstname</li>";
    echo "<li><strong>Last Name:</strong> $lastname</li>";
    echo "<li><strong>Email:</strong> $email</li>";
    echo "<li><strong>Gender:</strong> $gender</li>";

    // Show interests
    if (count($interests) > 0) {
        echo "<li><strong>Interests:</strong> ";
        for ($i = 0; $i < count($interests); $i++) {
            echo htmlspecialchars($interests[$i]);
            if ($i < count($interests) - 1) {
                echo ", ";
            }
        }
        echo "</li>";
    } else {
        echo "<li><strong>Interests:</strong> None selected</li>";
    }

    echo "<li><strong>Comments:</strong> " . htmlspecialchars($comments) . "</li>";
    echo "</ul>";
} else {
    echo "<h1>Warning!</h1>";
    echo "<p>The following fields are missing:</p>";
    echo "<ul>";

    foreach ($missing as $field) {
        echo "<li>" . htmlspecialchars($field) . "</li>";
    }

    echo "</ul>";
    echo "<p>Please go back and fill out the missing fields.</p>";
}

// Include footer
include("footer.php");
?>