<?php

// Collect form data
$firstname = trim($_POST['firstname']);
$lastname  = trim($_POST['lastname']);
$email     = trim($_POST['email']);
$gender    = isset($_POST['gender']) ? $_POST['gender'] : "";
$comments  = trim($_POST['comments']);
$interests = isset($_POST['interests']) ? $_POST['interests'] : [];

// Keep track of missing fields
$missing = array();

if (empty($firstname)) { $missing[] = "First Name"; }
if (empty($lastname))  { $missing[] = "Last Name"; }
if (empty($email))     { $missing[] = "Email"; }
if (empty($gender))    { $missing[] = "Gender"; }
if (empty($comments))  { $missing[] = "Comments"; }

// Display results
if (count($missing) == 0) {
    echo "<h1>Thank You!</h1>";
    echo "<p>Here is the information you submitted:</p>";
    echo "<ul>";
    echo "<li><strong>First Name:</strong> $firstname</li>";
    echo "<li><strong>Last Name:</strong> $lastname</li>";
    echo "<li><strong>Email:</strong> $email</li>";
    echo "<li><strong>Gender:</strong> $gender</li>";

    // Show interests
    if (count($interests) > 0) {
        echo "<li><strong>Interests:</strong> ";
        for ($i = 0; $i < count($interests); $i++) {
            echo $interests[$i];
            if ($i < count($interests) - 1) {
                echo ", ";
            }
        }
        echo "</li>";
    } else {
        echo "<li><strong>Interests:</strong> None selected</li>";
    }

    echo "<li><strong>Comments:</strong> $comments</li>";
    echo "</ul>";
} else {
    echo "<h1>Warning!</h1>";
    echo "<p>The following fields are missing:</p>";
    echo "<ul>";

    $i = 0;
    while ($i < count($missing)) {
        echo "<li>" . $missing[$i] . "</li>";
        $i++;
    }

    echo "</ul>";
    echo "<p>Please go back and fill out the missing fields.</p>";
}

?>